string GetDescription()
{
	return "Creates a simple intro sequence that is good for bass or melody";
}

void Render(RenderPart @p)
{
	Log("doing simple chord smooth...");
	
	int upto = p.GetHarmonicEventPitch(0,0);
	Time t1;
	t1.m_Bar = p.GetStartBar();
	t1.m_Pos = -1.5;
	
	double len = RndFloat(0.25, 0.5);
	
	if (RndInt(0,1) == 0) // diatonic
	{
		Time t2;
		t2 = t1;
		t2.m_Pos += len;
			
		p.AddNote(t1, t2, upto-3,102);	
		
		t1.m_Pos += 0.5;
		t2.m_Pos = t1.m_Pos + len;
		
		p.AddNote(t1, t2, upto-2,110);	
		
		t1.m_Pos += 0.5;
		t2.m_Pos = t1.m_Pos + len;
		
		p.AddNote(t1, t2, upto-1,115);	
		
		t1.m_Pos = 0;
		t2.m_Pos = len;
				
		p.AddNote(t1, t2, upto,127);	
	}
	else // diatonic
	{
		Time t2;
		t2 = t1;
		t2.m_Pos += len;
			
		p.AddNote(t1, t2, p.AlignPitch(upto,-3),102);	
		
		t1.m_Pos += 0.5;
		t2.m_Pos = t1.m_Pos + len;
		
		p.AddNote(t1, t2, p.AlignPitch(upto,-2),102);	
		
		t1.m_Pos += 0.5;
		t2.m_Pos = t1.m_Pos + len;
		
		p.AddNote(t1, t2, p.AlignPitch(upto,-1),102);	
		
		t1.m_Pos = 0;
		t2.m_Pos = len;
				
		p.AddNote(t1, t2, upto,127);	
	}
	
}